/* Script for analysis of Turtle beams, with and without Flag set */
/*                                                                */
/* TTLhist.js version 0.1     24 / 5/ 2007                        */
/*                                                                */
/* Need proper error trapping                                     */
/*                                                                */
/* USE: cscript //nologo TTLhist.js W14180.DAT                    */
/*                                                                */
/* Bins by ..., -1<=x<0, 0<=x<1, 1<=x<2, ..., n<=x<fBinMax        */
/*                                                                */

/* Set this to include particles with Flag>=fThreshold            */
var fThreshold = 1.0;

var iOutDP=2; // Decimal places in output
var args, sFileName, sData, fLowEnd, fInputVal, iInputBinX, iInputBinY;
var iCountFlg=0, iLoop=0;

/* Histogram properties (BinMax should be exact multiple of BinWidth): */
//var fBinWidth=0.1, fBinMax=50; // 50 cm radius, 1mm resn. Hence need 2*500 bins + 2
var fBinWidth=1.0, fBinMax=20; // 20 cm radius, 1cm resn.

/* Half-width of stripe used for profile [cm] */
var fProfileBand=0.2;

/* Parser output: */
var fX, fXp, fY, fYp, fPtot, fFlag, iTIndex;

args=WScript.FullName;
if (args.indexOf("WScript.exe") != -1) {
	WScript.echo("Please run me using CScript!");
	WScript.quit();
}

args = WScript.arguments;
if (args.length == 0) {
	// User didn't specify arguments, so quit and display usage
	WScript.echo("USAGE:  cscript TtlHist.js TtlOutputFile");
	WScript.echo("");
	WScript.echo("        Histogram bins for beam profile from a Turtle particle dump.");
	WScript.echo("");
	WScript.echo("        Modify fBinWidth and fBinMax to define histogram bins");
	WScript.echo("        and fProfileBand to change width of stripe used for profile.\n");
	WScript.quit();
} else {
 	sFileName=args(0);
}

/* Histogram bins */
try {
var iProfileX = new Array( (2*fBinMax/fBinWidth ) + 2);
var iProfileY = new Array( (2*fBinMax/fBinWidth ) + 2);
var iProjectX = new Array( (2*fBinMax/fBinWidth ) + 2);
var iProjectY = new Array( (2*fBinMax/fBinWidth ) + 2);
} catch (e) {
// catch RangeError if problem
 	WScript.echo("Error type: " + e.name);
 	WScript.echo("Error type: " + e.message);
 	if (e.name == "RangeError") WScript.echo("\nProblem with requested number of histogram bins.\n");
	else WScript.echo("\nProblem creating histogram bins.\n");
	WScript.quit();
}

/* Init to zero */
do {
	iProfileX[iLoop] = 0;
	iLoop += 1;
} while (iLoop<iProfileX.length);
iLoop=0;
do {
	iProfileY[iLoop] = 0;
	iLoop += 1;
} while (iLoop<iProfileY.length);
iLoop=0;
do {
	iProjectX[iLoop] = 0;
	iLoop += 1;
} while (iLoop<iProjectX.length);
iLoop=0;
do {
	iProjectY[iLoop] = 0;
	iLoop += 1;
} while (iLoop<iProjectY.length);


WScript.echo("\nAnalysing: " + sFileName + ", with flag selection threshold >= " + fThreshold.toString());

var hFSO = WScript.CreateObject("Scripting.FileSystemObject");
var hFile = hFSO.OpenTextFile(sFileName, 1);

while (!hFile.AtEndOfStream) {
	// Read a line and split into that particle's values
	sData = hFile.ReadLine();
	sParticle = sData.split(/\s/);
	fX=parseFloat(sParticle[0]);
	fY=parseFloat(sParticle[2]);
	fXp=parseFloat(sParticle[1]);
	fYp=parseFloat(sParticle[3]);
	fPtot=parseFloat(sParticle[4]);
	fFlag=parseFloat(sParticle[5]);
	iTIndex=parseInt(sParticle[6]);

	// Increment relevant bins 
	if (fFlag >= fThreshold) {
		fInputVal=(fX/fBinWidth);
		iInputBinX=Math.floor(fInputVal) + Math.round(fBinMax/fBinWidth) + 1;
		if (iInputBinX<0) iInputBinX=0;			   // Under bin
		if (fX>=fBinMax) iInputBinX=(iProjectX.length -1); // Over bin	

		iProjectX[iInputBinX] += 1;


		fInputVal=(fY/fBinWidth);
		iInputBinY=Math.floor(fInputVal) + Math.round(fBinMax/fBinWidth) + 1;
		if (iInputBinY<0) iInputBinY=0;			   // Under bin
		if (fY>=fBinMax) iInputBinY=(iProjectY.length -1); // Over bin	

		iProjectY[iInputBinY] += 1;

		if (Math.abs(fY) <= fProfileBand) iProfileX[iInputBinX] += 1;
		if (Math.abs(fX) <= fProfileBand) iProfileY[iInputBinY] += 1;

//		iCountFlg += 1;
	}

//	WScript.echo(sData);
//	WScript.echo("X= " + fX + "   X' = "+ fXp +"   Flag = "+ fFlag + " Turtle index = "+ iTIndex);
//	WScript.echo("X= " + fX + "   fInputVal= " +fInputVal+ "    iInputBin= " +iInputBinX);
}

hFile.Close(); 


/* Display results */
//WScript.echo("Data based on "+ iCountFlg + "particles");
WScript.echo("Bin lower limit\tx-Projection  \ty-Projection  \tx-Profile     \ty-Profile");
WScript.echo("UNDER\t\t"+ iProjectX[0] + "\t\t" + iProjectY[0] + "\t\t" + iProfileX[0]  + "\t\t" + iProfileY[0]);
iLoop=1;
fLowEnd = (fBinMax * -1.0) - fBinWidth;
do {
	fLowEnd += fBinWidth;
	WScript.echo("" + fLowEnd.toFixed(iOutDP) + "\t\t"+ iProjectX[iLoop] + "\t\t" + iProjectY[iLoop] + "\t\t" + iProfileX[iLoop]  + "\t\t" + iProfileY[iLoop]);
	iLoop += 1;
} while (iLoop<(iProjectX.length - 1));
fLowEnd += fBinWidth;
WScript.echo("" + fLowEnd.toFixed(iOutDP) + " & OVER\t"+ iProjectX[iLoop] + "\t\t" + iProjectY[iLoop] + "\t\t" + iProfileX[iLoop]  + "\t\t" + iProfileY[iLoop]);


//WScript.echo("Final line of input file (parsed):");
//WScript.echo(fX + "\t" + fXp + "\t" + fY + "\t" + fYp + "\t" + fPtot + "\t" + fFlag + "\t" + iTIndex);

WScript.quit();
