/* bossmin - an example that emulates data being published into R-GMA by a BOSS 'test' job. */
/*            the R-GMA C++ API is used to create two CircularBufferProducers               */
/*                                                                                          */
/* Usage: bossmin [iterations] [jobId]                                                      */

#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include "bossmin.h"

// Copy or full path - don't mix this example with real BOSS:
#include "BossConfig.h"

/* BOSS job ID to pretend to be: */
#define BOSS_JOB_ID "42"

/* Global var - weird fudge to emulate what happens in BOSS */
int iJobId=atoi(BOSS_JOB_ID);
char acHostName[64]="young";
 
Boss::Boss()
{
	// Fudge to get start time for dummy
	sprintf(acTStart, "%li", (long int)time(NULL));


	sprintf(acJobId, "%d", iJobId);

std::cout << "Create prod:\n";

	// Creates a new producer of bossJobExOutStandardInfo, filled at start and end of run
	// Sample withOUT predicate: pJobProducer= new edg::info::CircularBufferProducer ("bossJobExOutStandardInfo","",0);
	pJobProducer= new edg::info::CircularBufferProducer ("bossJobExOutStandardInfo",
		"WHERE (bossDatabaseHost=\'" BOSS_DB_HOST "." BOSS_DB_DOMAIN "\' AND bossDatabaseName=\'" BOSS_DB_NAME 
		"\' AND bossJobId=\'" + (string)acJobId + "\')",
		0);

std::cout << "Set buffer:\n";


	// This line sets the buffer size to 2 - this info only sent twice.
	pJobProducer->setRemoteBufferSize(2);

	// Inserts job start info into the producer.
	sprintf(acTStamp, "%li", (long int)time(NULL));
	// Sample withOUT predicate: pMessageProducer= new edg::info::CircularBufferProducer ("bossJobExOutMessage","",0);
	pJobProducer->insert("INSERT into bossJobExOutStandardInfo VALUES (\'" BOSS_DB_HOST "." BOSS_DB_DOMAIN "\',\'" BOSS_DB_NAME 
		"\',\'" + (string)acJobId + "\',\'"+ (string)acHostName +"\',\'ExecPath\',\'ExecUser\',\'" + (string)acTStart + 
		"\',NULL,NULL,NULL,\'" + (string)acTStamp + "\')");
	// was ExecHost and TStart - BOSS will supply these 
	
	// Creates a new message producer, into table bossJobExOutMessage
	pMessageProducer= new edg::info::CircularBufferProducer ("bossJobExOutMessage",
		"WHERE (bossDatabaseHost=\'" BOSS_DB_HOST "." BOSS_DB_DOMAIN "\' AND bossDatabaseName=\'" BOSS_DB_NAME 
		"\' AND bossJobId=\'" + (string)acJobId + "\')",
		0);
	// This line sets the buffer size to 10 - which means that 10 rows can be inserted until the buffer starts to be overwritten.
	pMessageProducer->setRemoteBufferSize(10);
}

int Boss::updateJobParameter(int idnum, string tab, string key, string val) 
{
	sprintf(acJobId, "%d", idnum);
	sprintf(acTStamp, "%li", (long int)time(NULL));

	string sUpdateQuery = "INSERT into bossJobExOutMessage VALUES (\'" BOSS_DB_HOST "." BOSS_DB_DOMAIN "\',\'" BOSS_DB_NAME 
		"\',\'" + (string)acJobId + "\',\'" + tab + "\',\'" + key + "\',\'" + val + "\',\'" + (string)acTStamp + "\');";

	// Inserts a row into the message producer
	pMessageProducer->insert(sUpdateQuery);
	return 0;
}

Boss::~Boss(){
	/*cleans up */
	// Insert job end info into the producer
	sprintf(acJobId, "%d", iJobId);
	sprintf(acTStamp, "%li", (long int)time(NULL));
	pJobProducer->insert("INSERT into bossJobExOutStandardInfo VALUES (\'" BOSS_DB_HOST "." BOSS_DB_DOMAIN "\',\'" BOSS_DB_NAME 
		"\',\'" + (string)acJobId + "\',\'" + (string)acHostName + "\',\'ExecPath\',\'ExecUser\',\'" + (string)acTStart + 
		"\',\'" + (string)acTStamp + "\',\'TStat\',\'RetCode\',\'" + (string)acTStamp + "\')");
	// was ExecHost, TStart and TStop - BOSS will supply these 


	delete pJobProducer;

	delete pMessageProducer;
}


int main(int argc, char** argv) {

  int iNumIter=0;
  if (argc > 1) iNumIter=iNumIter=atoi(argv[1]);
  if (iNumIter < 1) { 
	iNumIter=1;
  }

  if (argc > 2) iJobId=atoi(argv[2]);
  if (iJobId < 1) { 
	iJobId=atoi(BOSS_JOB_ID);
  }

  ifstream fIn("/etc/HOSTNAME");
  if (!fIn) {
	std::cout << "Can't get hostname\n\n";
	// return 1;
  }

  fIn >> acHostName;
  fIn.close();
  
  /*The next couple of lines is used to initialise log4cpp*/
  string initFileName = "./log4cpp.init";
   try {
    log4cpp::SimpleConfigurator::configure(initFileName);
  } catch(log4cpp::ConfigureFailure& f) {
    std::cout << "Log4cpp Configure Problem " << f.what() << std::endl;
    return -1;
  }

  Boss boss;

  // Start message
  boss.updateJobParameter( iJobId, "test", "comment", "I\'\'ve started...");

  // Loop through some iterations
  char acCount[50];
  for (int iCount=0; iCount<iNumIter; iCount+=1) {
	std::cout << "Waiting 2 seconds" << std::endl;
	system("sleep 2s");

	sprintf(acCount, "%d", iCount);
	boss.updateJobParameter( iJobId, "test", "counter", (string)acCount);
  }

  // End message
  boss.updateJobParameter( iJobId, "test", "comment", "... so I\'\'ll finish.");

  return 0;
}
