// (C) PPK / JJN
// See licence info at end 

import org.edg.info.*;
import java.net.*;
import java.io.*;
import java.util.*;

public class BossProducer {
    
    private StreamProducer wrapperProd;
    private String rgmaTableName="bossJobExOutMessage4";
    private String publishMe;
    private String bossDatabaseHost;
    private String bossDatabaseName;
    private String bossJobType;
    private final int bossJobID;
    private final long t_Start;
    private boolean haveProducer = false;

    BossProducer(String jobType, int jobID) {

	bossJobID=jobID;
	bossJobType=jobType;

	// Store start time to work out statistics later
	t_Start= System.currentTimeMillis();

	String E_HOST;
	String E_PATH;
	String E_USR;

        // Need some way to find out the following:
        bossDatabaseHost = "young.brunel.ac.uk:3306";
	bossDatabaseName = "bossDummyProducer";
	E_HOST = "newton";
	E_PATH = "/opt/edg/share/";
	E_USR = "Montmorency";

        // create Stream Producer
        try
        {
          wrapperProd = new StreamProducer();

	  // Aping Rob:
	  String bossJobExTable = "CREATE TABLE " + rgmaTableName + " " +
            "(bossDatabaseHost VARCHAR(200) PRIMARY KEY, " +
            "bossDatabaseName VARCHAR(200) PRIMARY KEY, " +
            "bossJobId INT PRIMARY KEY, " +
            "bossJobtype VARCHAR(31), " +
            "bossVarName VARCHAR(31) PRIMARY KEY, " +
            "bossVarValue VARCHAR(31), " +
            "timestamp VARCHAR(15))";

/*	  wrapperProd.declareTable(rgmaTableName, "", bossJobExTable);
*/

	  // Add predicate:
	  wrapperProd.declareTable(rgmaTableName,
		"WHERE (bossDatabaseHost='"+bossDatabaseHost+
			"' AND bossDatabaseName='"+bossDatabaseName+
			"' AND bossJobId="+bossJobID+")",
		bossJobExTable);


/*	  // Simplistic approach
	  wrapperProd.declareTable(rgmaTableName,"");
*/
/*	  // Or full declaration here!
	  wrapperProd.declareTable(rgmaTableName,
			"WHERE (bossDatabaseHost='"+bossDatabaseHost+
			"' AND bossDatabaseName='"+bossDatabaseName+
			"' AND bossJobId="+bossJobID+")");
*/
/* This is what Rob did:
        this.tableName = "bossJobExOutMessage4";
        this.bossJobExTable = "CREATE TABLE " + tableName + " " +
            "(bossDatabaseHost VARCHAR(200) PRIMARY KEY, " +
            "bossDatabaseName VARCHAR(200) PRIMARY KEY, " +
            "bossJobId INT PRIMARY KEY, " +
            "bossJobtype VARCHAR(31), " +
            "bossVarName VARCHAR(31) PRIMARY KEY, " +
            "bossVarValue VARCHAR(31), " +
            "timestamp VARCHAR(15))";

          loadInfo = new StreamProducer();
          loadInfo.declareTable(tableName, "", bossJobExTable);

   This is what is used in archiver:
        // The table name to be archived
        String tableName = "bossJobExOutMessage4";
        // The table description of the table, this should match the description defined under bossJob 
        String bossJobExTable = "CREATE TABLE " + tableName + " " +
            "(bossDatabaseHost VARCHAR(200) PRIMARY KEY, " +
            "bossDatabaseName VARCHAR(200) PRIMARY KEY, " +
            "bossJobId INT PRIMARY KEY, " +
            "bossJobtype VARCHAR(31), " +
            "bossVarName VARCHAR(31) PRIMARY KEY, " +
            "bossVarValue VARCHAR(31), " +
            "timestamp VARCHAR(15))";
*/

          // What should following values be?
	  wrapperProd.setMinRetentionPeriod(new TimeInterval(600));    // 5 min
	  wrapperProd.setTerminationInterval(new TimeInterval(21600)); // 3 hrs
	  haveProducer = true;
        } catch (RGMAException e) {
            System.out.println("Could not create StreamProducer " + e);
            // wrapperProd.close();
            System.exit(1);
        } 

        // Insert E_HOST E_USR E_PATH and T_START into JOB table
        publishParameter("JOB", "E_HOST",  E_HOST);
        publishParameter("JOB", "E_USR",    E_USR);
        publishParameter("JOB", "E_PATH",  E_PATH);
        publishParameter("JOB", "T_START", String.valueOf(t_Start));

    }

    public void update(String paramName, String newValue) {
       if (haveProducer) {
            // publish the information
            try {
		publishParameter(bossJobType, paramName, newValue);            
            } catch (Exception e) {
		System.out.println("Update failed: " + e);
            }
       } else {
	    // throw some sort of exception?
       }
    }

    private void publishParameter(String jobType, String paramName, String newValue) {

            // Create insert statement
            publishMe = 
                "INSERT INTO " + rgmaTableName +
                // " (bossDatabaseHost, bossDatabaseName, bossJobId,timeStamp)" +
                " VALUES ('" + bossDatabaseHost + "'" 
               +",'" + bossDatabaseName + "'"
               +",'" + bossJobID        + "'"
               +",'" + jobType          + "'"
               +",'" + paramName        + "'"
               +",'" + newValue         + "'"
               +",'" + String.valueOf(System.currentTimeMillis()) +  "');";
            System.out.println("L:" + publishMe + "\n");
            
            // publish the information
            try {
                wrapperProd.insert(publishMe);            
            } catch (RGMAException e) {
                System.out.println("Could not publish data: " + e);
            }
    }

    // The "destructor":
    public void close(String returnCode) {

	   // Store end time to work out statistics
	   long t_Stop = System.currentTimeMillis();
	   String t_Stat = ""+( (t_Stop - t_Start)/1000l )+"s";

            // insert RET_CODE T_STAT T_STOP
            publishParameter("JOB", "RET_CODE", returnCode);
            publishParameter("JOB", "T_STAT",   t_Stat);
            publishParameter("JOB", "T_STOP",   String.valueOf(System.currentTimeMillis())); // pragmatic for benchmarks

            // Close producer.
            try {
		wrapperProd.undeclareTable(rgmaTableName);
                wrapperProd.close();            
		haveProducer=false;
            } catch (Exception e) {
                System.out.println("Could not close producer: " + e);
            }
    }
}


/*
Copyright (c) 2003, Dr J.J. Nebrensky <j.nebrensky@brunel.ac.uk>, Brunel University.
All rights reserved.

This software includes voluntary contributions made to GridPP and the EU 
DataGrid. For more information on GridPP and the EU DataGrid, please see 
http://www.gridpp.ac.uk/ and http://www.eu-datagrid.org/

Installation, use, reproduction, display, modification and redistribution 
of this software, with or without modification, in source and binary 
forms, are permitted. Any exercise of rights under this license by you or 
your sub-licensees is subject to the following conditions:

1. Redistributions of this software, with or without modification, must 
   reproduce the above copyright notice and the above license statement as 
   well as this list of conditions, in the software, the user 
   documentation and any other materials provided with the software.

2. The user documentation, if any, included with a redistribution, must 
   include the following notice: "This product includes software developed 
   by GridPP and the EU DataGrid (http://www.gridpp.ac.uk/ and 
   http://www.eu-datagrid.org/)."   
   Alternatively, if that is where third-party acknowledgments normally 
   appear, this acknowledgment must be reproduced in the software itself.

3. The names "GridPP", "GridPP Collaboration", "EDG", "EDG Toolkit", 
   "EU DataGrid" and "EU DataGrid Project" may not be used to endorse or 
   promote software, or products derived therefrom, except with prior 
   written permission by license@gridpp.ac.uk (for GridPP) and 
   hep-project-grid-edg-license@cern.ch (for EDG.)

4. You are under no obligation to provide anyone with any bug fixes, 
   patches, upgrades or other modifications, enhancements or derivatives 
   of the features,functionality or performance of this software that you 
   may develop. However, if you publish or distribute your modifications, 
   enhancements or derivative works without contemporaneously requiring 
   users to enter into a separate written license agreement, then you are 
   deemed to have granted participants in GridPP or the EU DataGrid a 
   worldwide, non-exclusive, royalty-free, perpetual license to install, 
   use, reproduce, display, modify, redistribute and sub-license your 
   modifications, enhancements or derivative works, whether in binary or 
   source code form, under the license conditions stated in this list of 
   conditions.

5. DISCLAIMER
   THIS SOFTWARE IS PROVIDED BY GRIDPP, THE EU DATAGRID AND OTHER 
   CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, 
   BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, OF 
   SATISFACTORY QUALITY, AND FITNESS FOR A PARTICULAR PURPOSE OR USE ARE 
   DISCLAIMED. THE EU DATAGRID AND CONTRIBUTORS MAKE NO REPRESENTATION 
   THAT THE SOFTWARE, MODIFICATIONS, ENHANCEMENTS OR DERIVATIVE WORKS 
   THEREOF, WILL NOT INFRINGE ANY PATENT, COPYRIGHT, TRADE SECRET OR OTHER 
   PROPRIETARY RIGHT. 

6. LIMITATION OF LIABILITY
   GRIDPP, THE EU DATAGRID AND OTHER CONTRIBUTORS SHALL HAVE NO LIABILITY 
   TO LICENSEE OR OTHER PERSONS FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, 
   CONSEQUENTIAL, EXEMPLARY, OR PUNITIVE DAMAGES OF ANY CHARACTER 
   INCLUDING, WITHOUT LIMITATION, PROCUREMENT OF SUBSTITUTE GOODS OR 
   SERVICES, LOSS OF USE, DATA OR PROFITS, OR BUSINESS INTERRUPTION, 
   HOWEVER CAUSED AND ON ANY THEORY OF CONTRACT, WARRANTY, TORT (INCLUDING 
   NEGLIGENCE), PRODUCT LIABILITY OR OTHERWISE, ARISING IN ANY WAY OUT OF 
   THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH 
   DAMAGES.
*/
