/*
 * jobProfile.java
 *
 * Created on 10 October 2003, 09:33
 */

/**
 *
 * @author  Paul Kyberd
 */
public class jobProfile {
    
    int numb_phases=4;
    int[] meanInterval  = new int[numb_phases];
    int[] widthInterval = new int[numb_phases];
    int[] phaseLength   = new int[numb_phases];

    private boolean another;
    private double x1,x2, y1, y2;
    /** Creates a new instance of jobProfile */
    public jobProfile() {
        /* mean time between messages in the phases of the job 
           this leaves the decision as to the distribution to be decided elsewhere */
        meanInterval[0] = 50;
        meanInterval[1] = 9000;
        meanInterval[2] = 900000;
        meanInterval[3] = 100;
        widthInterval[0] = 0;
        widthInterval[1] = 200;
        widthInterval[2] = 500000;
        widthInterval[3] = 0;
        /* phase length is the time (in milliseconds) the phase lasts */
        phaseLength[0] = 1000;
	phaseLength[1] = 9001;
        phaseLength[2] = 60000;
        phaseLength[3] = 1000;        
    }
    
    int getPhases() {
        return numb_phases;
    }
    
    int meanInterval(int phase) {
        return meanInterval[phase];
    }
    
    int getDuration(int phase) {
        return phaseLength[phase];
    }
    
    int getNumberMessages(int phase) {
        double nMess = (double)phaseLength[phase]/(double)meanInterval[phase];
        return (int)nMess;
    }

    int getSleepTime(int phase) {
	int sleepTime = 0;

	if (phase ==0) {
	    sleepTime = meanInterval[0];
	}

	if (phase ==1) {
	    sleepTime = (int)(meanInterval[1] - widthInterval[1] +
                                (Math.random()*2*widthInterval[1]));
	}

	if (phase ==2) {
	    if (another) {
		sleepTime = (int)x2;
// no idea what this means! JJN		another = .false.;
		another = false;
	    }else{
		y1 = Math.random();
		y2 = Math.random();
		double s = Math.sqrt(-2.0*Math.log(y1));
		x1 = s*Math.cos(2*Math.PI*y2);
		x2 = s*Math.sin(2*Math.PI*y2);
		sleepTime = (int)x1;
// or this		another = .true.;
		another = true;
	    }
	}

	if (phase ==3) {
	    sleepTime = meanInterval[3];
	}
	return sleepTime;
    }
    
}
