/*
 * bossJob.java
 *
 * Created on 10 October 2003, 09:48
 */

import org.edg.info.RGMAException;
import org.edg.info.StreamProducer;
import org.edg.info.TimeInterval;

/**
 *
 * @author  Paul Kyberd
 */
public class bossJob extends Thread {
    
    private int ID;
    private jobProfile profile;
    private BossProducer wrapper;

    /**
     * XXX NB:
     *
     * Make changes to the table being published here.
     */
    public bossJob(){
	// 
    }
	

    /** Creates a new instance of bossJob */
    public bossJob(int ID, jobProfile profile) {
	this.ID = ID;
        this.profile = profile;
    }

    public void run() {
        int sleepTime;
	wrapper = new BossProducer("cmsim",ID);

        // Loop over phases
        for (int jobPhase=1; jobPhase <= profile.getPhases(); jobPhase++) {
            System.out.println(" job " + ID + "  Phase number" + jobPhase);
            int reps = profile.getNumberMessages(jobPhase);
            for (int message=0; message < reps; message++) {
		// Now to get a time interval
                sleepTime = profile.getSleepTime(jobPhase);
		try {
//                  System.out.println("Sleeping "+ sleepTime +" ms.");
                    // n.b. JVM rounds up to multiple of 10 ms, and adds on a 10 ms overhead
                    if (sleepTime>10) sleepTime-=10;
                    Thread.sleep(sleepTime);
                } catch (InterruptedException e) {
		    e.printStackTrace();
		}
		// publish data 
		int value = 1000*jobPhase+message;
		wrapper.update("Parameter",""+value+" is the new value, some padding");
            }
        }
	wrapper.close("0");
        System.out.println("Ending job " + ID);
    }
}
