/*
 * go.java
 *
 * Created on 10 October 2003, 09:29
 */

// JJN 18/10 added command-line args

/**
 *
 * @author  Paul Kyberd
 */
public class go extends Thread {
    
    private static int jobGap=1000;        // interval between thread starts (ms)

    /** Creates a new instance of go */
    public go() {
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {

	if (args.length < 1) {
            System.out.println("You must provide an initial jobID.");
            System.out.println("Usage: go <startID> [<numberJobs>]");
            System.exit(1);
	}

	int numberJobs = 50;
	int startID = Integer.parseInt(args[0]);

	if (args.length > 1) {
		numberJobs = Integer.parseInt(args[1]);
		if (numberJobs < 1) {
			System.out.println("Eh? Stupid number of jobs requested");
			System.exit(1);
		} // also check for max number ?
	}

        bossJob[] jobList = new bossJob[numberJobs];

        jobProfile a = new jobProfile();

        for (int i=0; i<a.getPhases(); i++) {
            System.out.println("length " + a.getDuration(i));
            System.out.println("interval " + a.meanInterval(i));
            System.out.println("messages " + a.getNumberMessages(i));
        }

        for (int jC=0;jC<numberJobs;jC++) {
          jobList[jC]  = new bossJob((startID+jC), a);
        }

        // uncomment this loop to start as fast as possible  - and comment the next loop 
        /*        for (int jC=0;jC<numberJobs;jC++) {
          jobList[jC].start();
        }*/

        for (int jC=0;jC<numberJobs;jC++) {
          jobList[jC].start();
          try {
              Thread.sleep(jobGap);
          } catch (InterruptedException e) {
          }
        }
    }
    
    public void run() {        
    }
    
}
