/*
 * jobProfile.java
 *
 * Created on 10 October 2003, 09:33
 */

/**
 *
 * @author  Paul Kyberd
 */
public class jobProfile {
    
    int numb_phases=5;

    // Phase numbers start at 1
    int[] meanInterval  = new int[numb_phases+1];
    int[] widthInterval = new int[numb_phases+1];
    int[] phaseLength   = new int[numb_phases+1];
    int[] messgCounter  = new int[numb_phases+1];
    int[] sleptSoFar    = new int[numb_phases+1];

    private int target;
    private boolean another;
    private double x1,x2, y1, y2;

    /** Creates a new instance of jobProfile */
    public jobProfile() {
        /* mean time between messages in the phases of the job 
           this leaves the decision as to the distribution to be decided elsewhere */
        /* Altered to match IEEE paper values for CMSIM - JJN 12/10/04 */
        meanInterval[1] = 50;      // Startup
        meanInterval[2] = 889999;  // Single msg
        meanInterval[3] = 8800000; // Main phase
        meanInterval[4] = 3300;    // Final - housekeeping
        meanInterval[5] = 100;     // Final - termination
        widthInterval[1] = 0;
        widthInterval[2] = 170000;
        widthInterval[3] = 480000;
        widthInterval[4] = 0;
        widthInterval[5] = 0;
        /* phase length is the time (in milliseconds) the phase lasts */
        phaseLength[1] = 1000;
	phaseLength[2] = 890000;
        phaseLength[3] = (6*8800000);
        phaseLength[4] = 99000;        
        phaseLength[5] = 1000;        

	//Sped up x100:
	meanInterval[3] = 88000; // Main phase
	widthInterval[3] = 4800;
	phaseLength[3] = (6*88000);

        /*--------- Original: -----
        meanInterval[1] = 50;
        meanInterval[2] = 9000;
        meanInterval[3] = 900000;
        meanInterval[4] = 100;
        widthInterval[1] = 0;
        widthInterval[2] = 200;
        widthInterval[3] = 500000;
        widthInterval[4] = 0;
        phaseLength[1] = 1000;
        phaseLength[2] = 9001;
        phaseLength[3] = 60000;
        phaseLength[4] = 1000;
        ----------------------------*/

        phaseLength[0]   = 0;   
        widthInterval[0] = 0;
        meanInterval[0]  = 10;

        for (int jobPhase=0; jobPhase <= numb_phases; jobPhase+=1) {
             messgCounter[jobPhase] = 0;
             sleptSoFar[jobPhase]   = 0;
        }
    }
    
    int getPhases() {
        return numb_phases;
    }
    
    int meanInterval(int phase) {
        return meanInterval[phase];
    }
    
    int getDuration(int phase) {
        return phaseLength[phase];
    }
    
    int getNumberMessages(int phase) {
        double nMess = (double)phaseLength[phase]/(double)meanInterval[phase];
        return (int)nMess;
    }

    int getSleepTime(int phase) {
	int sleepTime = 0;

        if (widthInterval[phase] == 0) {
            sleepTime = meanInterval[phase];
	} else {
            //centre of previous peak:
            target =  meanInterval[phase] * messgCounter[phase];
            //"start" of next peak 
            target += meanInterval[phase] - widthInterval[phase];
            //find offset in peak
            target += (int)(Math.random()*2*widthInterval[phase]);

            //Hence calc sleepTime
            sleepTime = target - sleptSoFar[phase];

            //Update totals
            messgCounter[phase] += 1;
            sleptSoFar[phase]   += sleepTime;
	}

	return sleepTime;
    }    

}
