#!/bin/sh

# n.b. Check specified users for mysql access

# Prints script usage
printUsage() {
    echo "$0 [log-file] [start-job-id] [end-job-id]" 
    exit 1
}

if [ ${#} -ne "3" ]; then
    printUsage
fi 

LOG_FILE=$1
CURR_ID=$2
LAST_ID=$3

# First check nothing obviously wrong has occurred
ERROR_COUNT=`grep -c Exception ${LOG_FILE}`

if [ ${ERROR_COUNT} -gt "0" ]; then
    grep -B 2 Exception ${LOG_FILE}
    echo
    echo "Encountered the above errors while running the test"
#    exit 0
fi

# Check number of inserted tuples match the archived number
INSERT_COUNT=`grep -c INSERT ${LOG_FILE}`
DB_COUNT=`echo "use HistTable; select count(*) from bossJobExOutMessage5"|mysql -u rgma_mon|grep [0-9]`
echo "Inserted tuples: $INSERT_COUNT, number tuples archived: $DB_COUNT"
# Create a counter, used to update the user of the anaylsis progress
NUM_ROWS_CHECKED=0

until [ ${CURR_ID} -gt ${LAST_ID} ]

do	
    # Added extra check in grep expression
    SENT=`grep -c \'bossDummyProducer\',\'${CURR_ID}\' ${LOG_FILE}`
#	echo "Sent ${SENT}"
    RCVD=`echo  "USE HistTable; SELECT bossJobID, timestamp, MeasurementTime FROM bossJobExOutMessage5 WHERE (bossJobID='${CURR_ID}');" | mysql -u rgma_mon | grep ${CURR_ID} | wc -l`
#	echo "Received ${RCVD}"
#Rcvd 3 times due to republishing:
#	RCVD=`expr ${RCVD} / 3`
    if [ ${SENT} -ne ${RCVD} ]; then
        echo "$((${SENT}-${RCVD})) dropped messages for job ${CURR_ID}"
    elif [ ${SENT} -eq 0 ]; then
	echo "No messages sent for job ${CURR_ID}"
    fi

    CURR_ID=`expr ${CURR_ID} + 1`
    NUM_ROWS_CHECKED=`expr ${NUM_ROWS_CHECKED} + 1`
    if [ `expr ${NUM_ROWS_CHECKED} % 100` -eq "0" ]; then
        echo "Checked: ${NUM_ROWS_CHECKED} Jobs "
    fi
done
