// /////////////////////////////////////////////////////////////////////
// Program: BOSS
// Version: 1.0
// File:    BossRealTimeRGMAUpdator.cc
// Authors: Claudio Grandi (INFN BO) / Henry Nebrensky (Brunel University)
// Date:    21/11/2002
// Note:
// /////////////////////////////////////////////////////////////////////

#include "BossConfig.h"

#include "BossRealTimeRGMAUpdator.h"
#include "BossOperatingSystem.h"

BossRealTimeRGMAUpdator::BossRealTimeRGMAUpdator(int jobid) 
  : BossRealTimeUpdator(jobid), 
  last_err_time_(0), 
  current_connection_(0) {
  string read;
  read = BOSS_DB_HOST;     hostname_    = parseInputString(read);
  read = BOSS_DB_DOMAIN;   domain_      = parseInputString(read);
  read = BOSS_DB_USER;     user_        = parseInputString(read);
  read = BOSS_DB_USER_PW;  passwd_      = parseInputString(read);
  read = BOSS_DB_NAME;     db_          = parseInputString(read);
  read = BOSS_DB_SOCKET;   unix_socket_ = parseInputString(read);
  port_        = BOSS_DB_PORT;


  // Creates a new message producer, into R-GMA table bossJobExOutMessage
  pMessageProducer= new edg::info::CircularBufferProducer ("bossJobExOutMessage",
  	"WHERE (bossDatabaseHost=\'" + (string)hostname_ + "." + domain_ + ":" + dec(port_) + 
		"\' AND bossDatabaseName=\'" + db_ + "\' AND bossJobId=\'" + dec(jobid) + "\')",
	0);


  // This line sets the buffer size to 10 - which means that 10 rows can be inserted until the buffer starts to be overwritten.
  pMessageProducer->setRemoteBufferSize(10);

  //cerr << "BossRealTimeRGMAUpdator::BossRealTimeRGMAUpdator creating producer" << endl;
}


BossRealTimeRGMAUpdator::~BossRealTimeRGMAUpdator() {

  // Destructor - kill producer
  delete pMessageProducer;
}


// 1 job updated
// 0 job not updated
int BossRealTimeRGMAUpdator::updateJobParameter(int id, string tab, string key, string val) {
  // send update message

  string sUpdateQuery = "INSERT into bossJobExOutMessage VALUES (\'" + (string)hostname_ + 
	"." + domain_ + 
	":" + dec(port_) + 
	"\',\'" + db_ + 
	"\',\'" + dec(id) + "\',\'" + tab + "\',\'" + key + "\',\'" + val + "\',\'" +
	dec( (long int)time(NULL) ) + "\');";

  // Inserts a row into the message producer
  pMessageProducer->insert(sUpdateQuery);

  return 1;
}


char* BossRealTimeRGMAUpdator::parseInputString(string read) {
  char* return_val = 0;
  if ( read != "NULL" ) {
    return_val = new char[read.size()+1]; 
    strcpy(return_val,read.c_str());
  }
  return return_val;
}


void BossRealTimeRGMAUpdator::fatal(string routine, int exit_code) {

  cerr << "Fatal error in Boss/R-GMA interface: " << routine << " --> " 
       << "\nplease check your MySQL server or contact the authors" <<  endl;
  exit(exit_code);  
}
/* e.g.
  if ( tryQuery(current_connection_, q) ) {
    fatal("getResults (1) ",800);
    return return_val;
  }
*/
