// /////////////////////////////////////////////////////////////////////
// Program: BOSS
// Version: 1.0
// File:    BossRealTimeRGMAUpdator.h
// Authors: Claudio Grandi (INFN BO) / Henry Nebrensky (Brunel University)
// Date:    21/11/2002
// Note:
// /////////////////////////////////////////////////////////////////////

#ifndef BOSS_REAL_TIME_RGMA_UPDATOR_H
#define BOSS_REAL_TIME_RGMA_UPDATOR_H

#include "BossRealTimeUpdator.h"
#include <mysql.h>
#include <string>

// For R-GMA:
#include "info/CircularBufferProducer.hh"
#include "log4cpp/Category.hh"
#include "log4cpp/SimpleConfigurator.hh"


class BossRealTimeRGMAUpdator : public BossRealTimeUpdator { 

private:
  char* hostname_;
  char* domain_;
  char* user_;
  char* passwd_;
  char* db_;
  unsigned int port_;
  char* unix_socket_;

// Next 3 aren't neede any more.
//  unsigned int client_flag_;
  time_t last_err_time_;
  MYSQL* current_connection_;

  //This is a class variable to enable the R-GMA producer to be accessed by all functions in the class
  edg::info::CircularBufferProducer *pMessageProducer;


public:

  explicit BossRealTimeRGMAUpdator(int); 
  virtual ~BossRealTimeRGMAUpdator();
  virtual int updateJobParameter(int, string, string, string);

private:
  char* parseInputString(string);
  void fatal(string, int);
};
#endif
