// /////////////////////////////////////////////////////////////////////
// Program: dbUpdator
// Version: 1.0
// File:    dbUpdatoRGMA.cpp
// Authors: Claudio Grandi (INFN BO) / Henry Nebrensky (Brunel University)
// Date:    15/11/2002
// Note:
// /////////////////////////////////////////////////////////////////////

#include <iostream>
#include <string>
#include <strstream>

#include "BossConfig.h"
#include "BossOperatingSystem.h"
#include "BossRealTimeRGMAUpdator.h"
#include "BossFileMonitor.h"

int main(int argc, char** argv) {

  //               ==========================
  //                 Preliminary operations
  //               ==========================

  BossOperatingSystem* sys=BossOperatingSystem::instance();
  
  // Job identifier
  if (argc < 2)
    return -1;
  int id = atol(argv[1]);
  string strid = dec(id);
  //Input (journal) file
  string journalFileN = string("BossJournal_")+strid+".txt";
  if (!sys->fileExist(journalFileN)) {
    cerr << "dbUpdator is unable to find journal file " << journalFileN 
	 << ". Abort!" << endl;
    return -2;
  }
  BossFileMonitor journal(journalFileN);
#ifdef LOGL3
  cerr << "dbUpdator is reading from: " << journalFileN << endl;
#endif

  //               ==========================
  //                   Start event loop
  //               ==========================
  // 
  BossRealTimeUpdator* upd = new BossRealTimeRGMAUpdator(id);
  //BossRealTimeUpdator* upd = new BossRealTimeUpdator(id);
  bool stop_loop = false;
  do {
    sys->sleep(BOSS_UPD_INTERVAL);// Update interval
    strstream frun;
    int newl = journal.newlines(frun, stop_loop);
    if (newl) {
      BossUpdateSet us(frun);
      if ( us.size() > 0 ) {
	//us.dump(cerr);
	upd->update(us);
      } 
    }
  } while (!stop_loop);
  delete upd;
  return 0;
}
