/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding.soap.internal;

import com.sun.xml.bind.api.BridgeContext;
import com.sun.xml.messaging.saaj.util.ByteOutputStream;
import com.sun.xml.ws.encoding.jaxb.JAXBBridgeInfo;
import com.sun.xml.ws.encoding.soap.SerializationException;
import com.sun.xml.ws.server.RuntimeContext;
import com.sun.xml.ws.util.ASCIIUtility;
import com.sun.xml.ws.util.ByteArrayDataSource;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.imageio.ImageIO;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;

public abstract class AttachmentBlock {
    public static AttachmentBlock fromDataHandler(String cid, DataHandler dh) {
        return new DataHandlerImpl(cid, dh);
    }

    public static AttachmentBlock fromSAAJ(AttachmentPart part) {
        return new SAAJImpl(part);
    }

    public static AttachmentBlock fromByteArray(String cid, byte[] data, int start, int len, String mimeType) {
        return new ByteArrayImpl(cid, data, start, len, mimeType);
    }

    public static AttachmentBlock fromByteArray(String cid, byte[] data, String mimeType) {
        return new ByteArrayImpl(cid, data, 0, data.length, mimeType);
    }

    public static AttachmentBlock fromJAXB(String cid, JAXBBridgeInfo bridgeInfo, RuntimeContext rtContext, String mimeType) {
        return new JAXBImpl(cid, bridgeInfo, rtContext, mimeType);
    }

    private AttachmentBlock() {
    }

    public abstract String getId();

    public final String getWSDLPartName() {
        String cId = this.getId();
        int index = cId.lastIndexOf(64, cId.length());
        if (index == -1) {
            return null;
        }
        String localPart = cId.substring(0, index);
        if ((index = localPart.lastIndexOf(61, localPart.length())) == -1) {
            return null;
        }
        try {
            return URLDecoder.decode(localPart.substring(0, index), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializationException(e);
        }
    }

    public abstract String getContentType();

    public byte[] asByteArray() {
        try {
            return ASCIIUtility.getBytes(this.asInputStream());
        }
        catch (IOException e) {
            throw new WebServiceException(e);
        }
    }

    public abstract DataHandler asDataHandler();

    public Source asSource() {
        return new StreamSource(this.asInputStream());
    }

    public InputStream asInputStream() {
        ByteOutputStream bos = new ByteOutputStream();
        try {
            this.writeTo((OutputStream)bos);
        }
        catch (IOException e) {
            throw new WebServiceException(e);
        }
        return bos.newInputStream();
    }

    public final void deserialize(BridgeContext bc, JAXBBridgeInfo bi) {
        bi.deserialize(this.asInputStream(), bc);
    }

    public void addTo(SOAPMessage msg) throws SOAPException {
        AttachmentPart part = msg.createAttachmentPart(this.asDataHandler());
        part.setContentId(this.getId());
        part.setMimeHeader("Content-transfer-encoding", "binary");
        msg.addAttachmentPart(part);
    }

    public void writeTo(OutputStream os) throws IOException {
        ASCIIUtility.copyStream(this.asInputStream(), os);
    }

    public final Image asImage() throws IOException {
        return ImageIO.read(this.asInputStream());
    }

    private static final class ByteArrayImpl
    extends AttachmentBlock {
        private final String cid;
        private byte[] data;
        private int start;
        private int len;
        private final String mimeType;

        public ByteArrayImpl(String cid, byte[] data, int start, int len, String mimeType) {
            this.cid = cid;
            this.data = data;
            this.start = start;
            this.len = len;
            this.mimeType = mimeType;
        }

        public String getId() {
            return this.cid;
        }

        public String getContentType() {
            return this.mimeType;
        }

        public byte[] asByteArray() {
            if (this.start != 0 || this.len != this.data.length) {
                byte[] exact = new byte[this.len];
                System.arraycopy(this.data, this.start, exact, 0, this.len);
                this.start = 0;
                this.data = exact;
            }
            return this.data;
        }

        public DataHandler asDataHandler() {
            return new DataHandler((DataSource)new ByteArrayDataSource(this.data, this.start, this.len, this.getContentType()));
        }

        public InputStream asInputStream() {
            return new ByteArrayInputStream(this.data, this.start, this.len);
        }

        public void addTo(SOAPMessage msg) throws SOAPException {
            AttachmentPart part = msg.createAttachmentPart();
            part.setRawContentBytes(this.data, this.start, this.len, this.getContentType());
            part.setContentId(this.getId());
            msg.addAttachmentPart(part);
        }

        public void writeTo(OutputStream os) throws IOException {
            os.write(this.data, this.start, this.len);
        }
    }

    private static final class DataHandlerImpl
    extends AttachmentBlock {
        private final String cid;
        private final DataHandler dh;

        public DataHandlerImpl(String cid, DataHandler dh) {
            this.cid = cid;
            this.dh = dh;
        }

        public String getId() {
            return this.cid;
        }

        public String getContentType() {
            return this.dh.getContentType();
        }

        public DataHandler asDataHandler() {
            return this.dh;
        }

        public InputStream asInputStream() {
            try {
                return this.dh.getInputStream();
            }
            catch (IOException e) {
                throw new WebServiceException(e);
            }
        }
    }

    private static final class JAXBImpl
    extends AttachmentBlock
    implements DataSource {
        private final String id;
        private final JAXBBridgeInfo bridgeInfo;
        private final RuntimeContext rtContext;
        private final String type;

        public JAXBImpl(String id, JAXBBridgeInfo bridgeInfo, RuntimeContext rtContext, String type) {
            this.id = id;
            this.bridgeInfo = bridgeInfo;
            this.rtContext = rtContext;
            this.type = type;
        }

        public String getId() {
            return this.id;
        }

        public String getContentType() {
            return this.type;
        }

        public DataHandler asDataHandler() {
            return new DataHandler((DataSource)this);
        }

        public InputStream getInputStream() {
            return this.asInputStream();
        }

        public String getName() {
            return null;
        }

        public OutputStream getOutputStream() {
            throw new UnsupportedOperationException();
        }

        public void writeTo(OutputStream os) {
            this.bridgeInfo.serialize(this.rtContext.getBridgeContext(), os, null);
        }
    }

    private static final class SAAJImpl
    extends AttachmentBlock {
        private final AttachmentPart ap;

        public SAAJImpl(AttachmentPart part) {
            this.ap = part;
        }

        public String getId() {
            return this.ap.getContentId();
        }

        public String getContentType() {
            return this.ap.getContentType();
        }

        public byte[] asByteArray() {
            try {
                return this.ap.getRawContentBytes();
            }
            catch (SOAPException e) {
                throw new WebServiceException(e);
            }
        }

        public DataHandler asDataHandler() {
            try {
                return this.ap.getDataHandler();
            }
            catch (SOAPException e) {
                throw new WebServiceException(e);
            }
        }

        public Source asSource() {
            try {
                return new StreamSource(this.ap.getRawContent());
            }
            catch (SOAPException e) {
                throw new WebServiceException(e);
            }
        }

        public InputStream asInputStream() {
            try {
                return this.ap.getRawContent();
            }
            catch (SOAPException e) {
                throw new WebServiceException(e);
            }
        }

        public void addTo(SOAPMessage msg) {
            msg.addAttachmentPart(this.ap);
        }
    }
}

