/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http.server;

import com.sun.net.httpserver.HttpExchange;
import com.sun.xml.ws.transport.WSConnectionImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerConnectionImpl
extends WSConnectionImpl {
    private HttpExchange httpExchange;
    private int status;
    private Map<String, List<String>> requestHeaders;
    private Map<String, List<String>> responseHeaders;
    private NoCloseInputStream is;
    private NoCloseOutputStream out;
    private boolean closedInput;
    private boolean closedOutput;

    public ServerConnectionImpl(HttpExchange httpTransaction) {
        this.httpExchange = httpTransaction;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.httpExchange.getRequestHeaders();
    }

    @Override
    public void setHeaders(Map<String, List<String>> headers) {
        this.responseHeaders = headers;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public int getStatus() {
        if (this.status == 0) {
            this.status = 500;
        }
        return this.status;
    }

    @Override
    public InputStream getInput() {
        if (this.is == null) {
            this.is = new NoCloseInputStream(this.httpExchange.getRequestBody());
        }
        return this.is;
    }

    @Override
    public OutputStream getOutput() {
        if (this.out == null) {
            try {
                this.closeInput();
                int len = 0;
                if (this.responseHeaders != null) {
                    for (Map.Entry<String, List<String>> entry : this.responseHeaders.entrySet()) {
                        String name = entry.getKey();
                        List<String> values = entry.getValue();
                        if (name.equals("Content-Length")) {
                            len = Integer.valueOf(values.get(0));
                            continue;
                        }
                        for (String value : values) {
                            this.httpExchange.getResponseHeaders().add(name, value);
                        }
                    }
                }
                this.httpExchange.sendResponseHeaders(this.getStatus(), len);
                this.out = new NoCloseOutputStream(this.httpExchange.getResponseBody());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return this.out;
    }

    @Override
    public void closeOutput() {
        if (this.out != null) {
            try {
                this.out.getOutputStream().close();
                this.closedOutput = true;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.out = null;
    }

    @Override
    public void closeInput() {
        if (this.is != null) {
            try {
                byte[] buf = new byte[1024];
                while (this.is.read(buf) != -1) {
                }
                this.is.getInputStream().close();
                this.closedInput = true;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.is = null;
    }

    @Override
    public void close() {
        this.httpExchange.close();
    }

    private static class NoCloseInputStream
    extends InputStream {
        private InputStream is;

        public NoCloseInputStream(InputStream is) {
            this.is = is;
        }

        public int read() throws IOException {
            return this.is.read();
        }

        public void close() throws IOException {
        }

        public InputStream getInputStream() {
            return this.is;
        }

        public int read(byte[] b) throws IOException {
            return this.is.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.is.read(b, off, len);
        }

        public long skip(long n) throws IOException {
            return this.is.skip(n);
        }

        public int available() throws IOException {
            return this.is.available();
        }

        public void mark(int readlimit) {
            this.is.mark(readlimit);
        }

        public void reset() throws IOException {
            this.is.reset();
        }

        public boolean markSupported() {
            return this.is.markSupported();
        }
    }

    private static class NoCloseOutputStream
    extends OutputStream {
        private OutputStream out;

        public NoCloseOutputStream(OutputStream out) {
            this.out = out;
        }

        public void write(int ch) throws IOException {
            this.out.write(ch);
        }

        public void close() throws IOException {
        }

        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public OutputStream getOutputStream() {
            return this.out;
        }
    }
}

