/*
 * This code is copyright Vikram Goyal; tech@craftbits.com
 */
package com.j2me.part3;

import java.util.Random;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.LayerManager;

public class CarSprite implements Runnable {

	public CarSprite(MyGameCanvas parent) {

		this.parent = parent;
		this.manager = parent.getManager();

	}

	public void start() {

		// first load the car image
		try {
		  carImage = Image.createImage("/car.png");
		} catch(Exception e) { System.err.println(e); return; }

		// next start the thread that will display cars
		// ar random locations
		runner = new Thread(this);
		runner.start();
	}

	public void run() {

		try {
		  while(true) {

				// create a random car
				randomCar();

				// wait before creating another one
			  Thread.currentThread().sleep(500);
			}
		} catch(Exception e) { System.err.println(e); }
	}

	// creates and displays a car at a random location
	private void randomCar() {

		// if maximum cars are being shown return
		if(currentCars == MAX_CARS) return;

		// create a new car sprite
		carSprite = new Sprite(carImage, 10, 10);

		// generate the random places where cars may appear
		int randomCarX = parent.getRandom().nextInt(parent.GAME_WIDTH);
		int randomCarY =
		  (parent.BASE -
		    parent.getRandom().nextInt(parent.MAX_HEIGHT + 1) -
		    carSprite.getHeight());

		// make sure that these places are within bounds
		if(randomCarX < parent.GAME_ORIGIN_X) randomCarX = parent.CENTER_X;
		if(randomCarY < (parent.BASE - parent.MAX_HEIGHT))
		  randomCarY = parent.CENTER_Y;

		// set this newly created car sprite in its random position
		carSprite.setPosition(randomCarX, randomCarY);

		// add it to the manager at index 0
		manager.insert(carSprite, 0);

		// increase the no of cars created
		currentCars++;

	}

	public void checkForCollision() {

		// if there are no cars being shown (only background and couple)
		if(manager.getSize() == 2) return;

		// iterate through the layers, remember don't worry about
		// the last two because they are the couple and background
		for(int i = 0; i < (manager.getSize() - 2); i++) {

			// if collision occurs
			if(parent.getCoupleSprite().collidesWith(
				(Sprite)manager.getLayerAt(i), true)) {

			  // remove the offending car
			  manager.remove(manager.getLayerAt(i));

			  // reduce the no of cars on display
			  currentCars--;

			  // and increase the no of cars hit
			  carsHit++;

			}
		}
	}

	// the no of cars hit

	public int getCarsHit() {
		return carsHit;
	}

	// the car sprite
	private Sprite carSprite;

	// the car image
	private Image carImage;

	// the no of current cars in display

	private int currentCars;

	// the parent canvas

	private MyGameCanvas parent;

	// the parent canvas's layer manager
	private LayerManager manager;

	// runner

	private Thread runner;

	// tracks the no of cars hit

	private int carsHit;

	// the maximum no of cars to create
	private static final int MAX_CARS = 20;

}

