/*
 * This code is copyright Vikram Goyal; tech@craftbits.com
 */
package com.j2me.part3;

import java.util.Timer;
import java.util.Random;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.TiledLayer;
import javax.microedition.lcdui.game.LayerManager;

import java.io.IOException;

public class MyGameCanvas
  extends GameCanvas implements Runnable {

	public MyGameCanvas() {
		super(true);
	}

	public void start() {

		try {

		  // create and load the couple image
		  // and then center it on screen when
		  // the MIDlet starts
		  coupleImg = Image.createImage("/couple2.png");
		  coupleX = CENTER_X;
		  coupleY = BASE;

		  // create the couple sprite
		  coupleSprite = new Sprite(coupleImg, 10, 10);

		  // and define its reference pixel
		  coupleSprite.defineReferencePixel(
				coupleSprite.getWidth()/2, coupleSprite.getHeight());

		  // creates the layermanager
		  manager = new LayerManager();

		  // and adds layers to it
		  manager.append(coupleSprite);

		  // creates the game background
		  createBackground();

		  manager.append(background);

		  // create the car sprite thread and start it
		  carSprite = new CarSprite(this);
		  carSprite.start();

		} catch(IOException ioex) { System.err.println(ioex); }

		// finally execute the current thread
		Thread runner = new Thread(this);
		runner.start();

	}

	public void run() {

		// before going in the loop,
		// start the timer clock with a
		// 30 seconds countdown
		clock = new Clock(30);
		new Timer().schedule(clock, 0, 1000);

		while(!stop) { // loop

  		// based on the structure

  		// first verify game state
  		verifyGameState();

  		// check user's input
  		checkUserInput();

  		// update screen
  		updateGameScreen(getGraphics());

			// and sleep, this controls
			// how fast refresh is done
			try {
			  Thread.currentThread().sleep(30);
			} catch(Exception e) {}

		}

		showGameScore(getGraphics());

	}

	// creates the background using TiledLayer
	private void createBackground() throws IOException {

		// load the image
		backgroundImg = Image.createImage("/tiledlayer1.png");

		// create the tiledlayer background
		background = new TiledLayer(5, 5, backgroundImg, 32, 32);

		// array that specifies what image goes where
		int[] cells = {
			3, 3, 3, 3, 3, // sky
			3, 3, 3, 3, 3, // sky
			1, 1, 1, 1, 1, // earth
			2, 2, 2, 2, 2, // sea
			2, 2, 2, 2, 2  // sea
		};

		// set the background with the images
		for (int i = 0; i < cells.length; i++) {

			int column = i % 5;
			int row = (i - column)/5;
			background.setCell(column, row, cells[i]);

		}

		// set the location of the background
		background.setPosition(GAME_ORIGIN_X, GAME_ORIGIN_Y);

	}

	// builds the game borders and background
	private void buildGameScreen(Graphics g) {

		// set the drawing color to black
		g.setColor(0x000000);

		// draw the surrounding rectangle
		g.drawRect(GAME_ORIGIN_X, GAME_ORIGIN_Y, GAME_WIDTH, GAME_HEIGHT);

		// draw the base line
		g.drawLine(GAME_ORIGIN_X, BASE, GAME_ORIGIN_X + GAME_WIDTH, BASE);

		// draw the maximum line to where the couple can jump to
		g.drawLine(GAME_ORIGIN_X, BASE - MAX_HEIGHT,
		  GAME_ORIGIN_X + GAME_WIDTH, BASE - MAX_HEIGHT);

		// draw the game background
		// background.paint(g);
		showTimeLeft(g);

	}

	private void verifyGameState() {

		// first check if the game is over
		if(clock.getTimeLeft() == 0) {
			stop = true;
			return;
		}

		// game not over, check for collisions
		carSprite.checkForCollision();
	}

	private void checkUserInput() {

		// get the state of keys
		int keyState = getKeyStates();

		// calculate the position for x axis
		calculateCoupleX(keyState);

		// this doesn't really depend on the users input
		calculateCoupleY(keyState);

	}

	private void updateGameScreen(Graphics g) {

	  // the next two lines clear the background
	  g.setColor(0xffffff);
		g.fillRect(0, 0, getWidth(), getHeight());

		// creates the game borders
		buildGameScreen(g);

		// draws the couple image according to current
		// desired positions
		/*g.drawImage(
			coupleImg, coupleX,
			coupleY, Graphics.HCENTER | Graphics.BOTTOM);*/

		// animates the sprite
		coupleSprite.nextFrame();

		// moves the sprite based on its reference pixel
		coupleSprite.setRefPixelPosition(coupleX, coupleY);

		// paints it on the buffer
		// coupleSprite.paint(g);

		// the manager paints all the layers
		manager.paint(g, 0, 0);

		// this call paints off screen buffer to screen
		flushGraphics();

	}

	private void showTimeLeft(Graphics g) {

		// what does the clock say
		int timeLeft = clock.getTimeLeft();

		// if less than 6 seconds left
		// flicker time with red and black
		if(timeLeft < 6) {
			if((timeLeft % 2) == 0)
			  g.setColor(0xff0000);
			else
			  g.setColor(0x000000);
		}

		// draw the time left string
		g.drawString("Time Left: " + timeLeft + " seconds", 0, 0, 0);

		// reset the color
		g.setColor(0x000000);

	}

	// at the end of the game show the score
	private void showGameScore(Graphics g) {

		// create a base rectangle
		g.setColor(0xffffff);
		g.fillRect(0, CENTER_Y - 20, getWidth(), 40);

		g.setColor(0x000000);

	  // and show the score
	  g.drawString("You hit " +
	    carSprite.getCarsHit() + " cars.",
	    CENTER_X, CENTER_Y,
	    Graphics.HCENTER | Graphics.BASELINE);

	  flushGraphics();
	}

	private void calculateCoupleX(int keyState) {

		// determines which way to move and changes the
		// x coordinate accordingly
		if((keyState & LEFT_PRESSED) != 0) {
				coupleX =
				  Math.max(
						GAME_ORIGIN_X + coupleSprite.getWidth()/2,
				    coupleX - dx);
		}
		else if((keyState & RIGHT_PRESSED) != 0) {
				coupleX =
				  Math.min(
						GAME_ORIGIN_X + GAME_WIDTH - coupleSprite.getWidth()/2,
				    coupleX + dx);;
		}

	}

	// this method makes the couple jump around random heights

	// the keystate is not required in this case as the users
	// input has no implication
	private void calculateCoupleY(int keyState) {

		// check if the couple were on the way up
		if(up) {

			// if yes, see if they have reached the current jump height
			if((coupleY > (BASE - jumpHeight + coupleSprite.getHeight()))) {

			  // if not, continue moving them up
			  coupleY -= dy;
			} else if(coupleY == (BASE - jumpHeight + coupleSprite.getHeight())) {

				// if yes, start moving them down
				coupleY += dy;

				// and change the flag
				up = false;
			}

		} else {

			// the couple are on their way down, have they reached base?
			if(coupleY < BASE) {

				// no, so keep moving them down
				coupleY += dy;

			} else if(coupleY == BASE) {

				// have reached base, so calculate a new
				// jump height which is not more than MAX_HEIGHT
				int hyper = random.nextInt(MAX_HEIGHT + 1);

			  // but make sure that this it is atleast greater than the image height
			  if(hyper > coupleSprite.getHeight()) jumpHeight = hyper;

				// move the image up
				coupleY -= dy;

				// and reset the flag
				up = true;

			}
		}

	}

	// accessor methods
	public Sprite getCoupleSprite() {
		return this.coupleSprite;
	}

  public LayerManager getManager() {
		return this.manager;
	}

	public Random getRandom() {
		return this.random;
	}

	// the center of the screen
	public final int CENTER_X = getWidth()/2;
	public final int CENTER_Y = getHeight()/2;

	// the game boundary
	public static final int GAME_WIDTH = 160;
	public static final int GAME_HEIGHT = 160;

	// the shifted x,y origin of the game
	public final int GAME_ORIGIN_X = (getWidth() - GAME_WIDTH)/2;
	public final int GAME_ORIGIN_Y = (getHeight() - GAME_HEIGHT)/2;

	// the height of sections below and above the couple
	public final int SECTION_HEIGHT = 64;

	// the base on which the couple will move
	public final int BASE = GAME_ORIGIN_Y + GAME_HEIGHT - SECTION_HEIGHT;

	// the max height the couples can jump
	public final int MAX_HEIGHT = 32;

	// the couple image
	private Image coupleImg;

	// the couple sprite
	private Sprite coupleSprite;

	// the background tiled image
	private Image backgroundImg;

	// the background using a tiledlayer
	private TiledLayer background;

	// the couple image coordinates
	private int coupleX;
	private int coupleY;

	// the distance to move in the x axis
	private int dx = 1;

	// the distance to move in the y axis
	private int dy = 1;

	// a flag to indicate which direction the couple are moving
	private boolean up = true;

	// indicates the random jump height, calculated for every jump
	private int jumpHeight = MAX_HEIGHT;

	// random number generator
	public Random random = new Random();

	// LayerManager
	private LayerManager manager;

	// the car sprite handler
	private CarSprite carSprite;

	// the clock
	private Clock clock;

	// the flag that tells the game to stop
	private boolean stop = false;

}