package lab3;
import java.io.*;
import javax.microedition.io.*;
import javax.microedition.lcdui.*;
import javax.microedition.midlet.MIDlet;

public class Lab3Midlet extends MIDlet implements CommandListener, Runnable {

    private Display display;

    private Thread httpThread;
    
    private Form fmUrl;
    private TextField tfUrl;
    private Command cmGo;
    private Command cmQuit;

    private Form fmDisplay;
    private Command cmBack;

    private Form fmWait;
    private Command cmCancel;

    public Lab3Midlet() {

        cmQuit = new Command("Quit", Command.EXIT, 1);
        cmCancel = new Command("Cancel", Command.CANCEL, 1);
        cmBack = new Command("Back", Command.BACK, 1);
        cmGo = new Command("Go", Command.OK, 1);
    
        fmUrl = new Form("Lab3 - HTTP");
        fmUrl.setCommandListener(this);
        fmUrl.addCommand(cmGo);
        fmUrl.addCommand(cmQuit);
        tfUrl = new TextField("Enter URL", "http://www.charcourt.com/hello-world.txt", 255, TextField.ANY);
        fmUrl.append(tfUrl);
        
        fmWait = new Form("Wait...");
        fmWait.setCommandListener(this);
        fmWait.addCommand(cmCancel);
        fmWait.append("Please wait...\nMaking connection...");

        fmDisplay = new Form("Data");
        fmDisplay.setCommandListener(this);
        fmDisplay.addCommand(cmBack);

    }

    public void run() {
        fmDisplay.deleteAll();
        HttpConnection connection = null;
        DataInputStream iStrm = null;

        try {
            connection = (HttpConnection) Connector.open(tfUrl.getString(), Connector.READ);
            connection.setRequestMethod(HttpConnection.GET);

            int responseCode = connection.getResponseCode();
            if (responseCode != HttpConnection.HTTP_OK) {
                fmDisplay.append("Failed!\n" + responseCode + ":" + connection.getResponseMessage());
                display.setCurrent(fmDisplay);
                return;
            }

            iStrm = connection.openDataInputStream();
            int ch;
            StringBuffer buffer = new StringBuffer();
            while ((ch = iStrm.read()) != -1) {
                buffer.append((char) ch);
            }
            fmDisplay.append(buffer.toString());
            
        } catch (IOException e) {
            fmDisplay.append("IOException: " + e.getMessage());
        } finally {
            try {
                if (iStrm != null) { iStrm.close(); }
                if (connection != null) { connection.close(); }
            } catch (Exception ignored) { }
        }
        display.setCurrent(fmDisplay);
    }

    protected void startApp() {
        display = Display.getDisplay(this);
        display.setCurrent(fmUrl);
    }


    public void commandAction(Command command, Displayable displayable) {
        if (command.equals(cmQuit)) {
            destroyApp(true);
        } else if (command.equals(cmGo)) {
            display.setCurrent(fmWait);
            httpThread = new Thread(this);
            httpThread.start();
        } else if (command.equals(cmCancel)) {
            httpThread.interrupt();
            httpThread = null;
            display.setCurrent(fmUrl);
        } else if (command.equals(cmBack)) {
            display.setCurrent(fmUrl);
        }
    }
    
    protected void pauseApp() {
        notifyPaused();
    }

    protected void destroyApp(boolean unconditional) {
        notifyDestroyed();
    }

}

